/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;
import org.eclipse.swt.events.*;

import intrinsic.Function;
import intrinsic.mx.events.*;
import intrinsic.mx.controls.*;

public class Scale extends Control {
	int minimum, maximum, selection, increment, pageIncrement;

public Scale (Composite parent, int style) {
	super (parent, checkStyle (style));
}

public void addSelectionListener (SelectionListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	TypedListener typedListener = new TypedListener (listener);
	addListener (SWT.Selection,typedListener);
	addListener (SWT.DefaultSelection,typedListener);
}

static int checkStyle (int style) {
	return checkBits (style, SWT.HORIZONTAL, SWT.VERTICAL, 0, 0, 0, 0);
}

void createHandle () {
	intrinsic.mx.controls.sliderClasses.Slider widget;
	if ((style & SWT.HORIZONTAL) != 0) {
		widget = new HSlider();
	} else {
		widget = new VSlider();
	}
	widget.liveDragging = true;
	widget.allowTrackClick = true;
	object = widget;
}

void createWidget() {
	super.createWidget ();
	setValues (0, 0, 100, 1, 10);
}

public int getIncrement () {
	checkWidget ();
	return increment;
}

public int getMaximum () {
	checkWidget ();
	return maximum;
}

public int getMinimum () {
	checkWidget ();
	return minimum;
}

public int getPageIncrement () {
	checkWidget ();
	return pageIncrement;
}

public int getSelection () {
	checkWidget ();
	return selection;
}

void hookEvents() {
	super.hookEvents();
	object.addEventListener (SliderEvent.CHANGE, sliderHandlerFunction ());
}

public void removeSelectionListener (SelectionListener listener) {
	checkWidget ();
	if (listener == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (eventTable == null) return;
	eventTable.unhook (SWT.Selection, listener);
	eventTable.unhook (SWT.DefaultSelection,listener);	
}

void sendSelection (int selection) {
	this.selection = selection;
	sendEvent (SWT.Selection);
}

public void setIncrement (int value) {
	setValues(selection, minimum, maximum, value, pageIncrement);
}

public void setMaximum (int value) {
	setValues(selection, minimum, value, increment, pageIncrement);
}

public void setMinimum (int value) {
	setValues(selection, value, maximum, increment, pageIncrement);
}

public void setPageIncrement (int value) {
	setValues(selection, minimum, maximum, increment, value);
}

public void setSelection (int value) {
	setValues(value, minimum, maximum, increment, pageIncrement);
}

void setValues (int selection, int minimum, int maximum, int increment, int pageIncrement) {
	checkWidget();
	this.selection = selection;
	this.minimum = minimum;
	this.maximum = maximum;
	this.increment = increment;
	this.pageIncrement = pageIncrement;
	intrinsic.mx.controls.sliderClasses.Slider widget = (intrinsic.mx.controls.sliderClasses.Slider)object;
	widget.minimum = minimum;
	widget.maximum = maximum;
	widget.value = selection;
	widget.snapInterval = increment;
	widget.tickInterval = pageIncrement;
}

void sliderHandler(SliderEvent event) {
	sendSelection((int)event.value);
}

native Function sliderHandlerFunction ()/*{
	return sliderHandler__Lmx_events_SliderEvent_2;
}*/;

}
